% Figures_2_3_4.m
% 
% reduced form figures
% 
%   - have to run VA_Shares_Components_Trends.m first
% 
% "The Past and Future of U.S. Structural Change" 
% Andrew Foerster, Andreas Hornstein, Pierre-Daniel Sarte, Mark Watson
% September 2025
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 

% -- Clear Workspace -- %
restoredefaultpath;
clear;
clc;
close all;

% -- File Directories -- % 
datadir = 'Data\DataReplication\DataFinal\'; 
outdir  = 'Tables\';
figdir  = 'Figures\';
matdir  = 'Output\';

% -- Add paths -- %
addpath('Functions\');
addpath('Utilities\')
addpath('Data\')

% Load Data
load([matdir 'VA_Shares_Components_Trends.mat']);
nS = size(va_shares,2);  % Number of sectors
T = size(va_shares,1);  % Number of time periods

% Compute Subcomponents of VA Shares

va_excl_nx_g = NaN(T,nS);
va_trend_excl_nx_g = NaN(T,nS);
for t = 1:T
    % actual data
    theta_t = theta(t,:)';
    gamma_t = gamma(t,:)';
    psi_x_t = psiX(t,:)';
    % psi_nx_t = psiNX_trend(t,:)';
    % psi_g_t = psiG_trend(t,:)';
    psi_nx_t = zeros(nS,1);  % Set to zero for this computation
    psi_g_t = zeros(nS,1);  % Set to zero for this computation
    Phi_t = squeeze(phi(:,:,t));
    Omega_t = squeeze(omega(:,:,t));
    parms_t = [theta_t;gamma_t;psi_g_t;psi_x_t;psi_nx_t;Phi_t(:);Omega_t(:)]; 
    va_excl_nx_g(t,:) = sV_compute(parms_t,nS)';

    % trend calculatin
    theta_t = theta_trend(t,:)';
    gamma_t = gamma_trend(t,:)';
    psi_x_t = psiX_trend(t,:)';
    % psi_nx_t = psiNX_trend(t,:)';
    % psi_g_t = psiG_trend(t,:)';
    psi_nx_t = zeros(nS,1);  % Set to zero for this computation
    psi_g_t = zeros(nS,1);  % Set to zero for this computation
    Phi_t = squeeze(phi_trend(:,:,t));
    Omega_t = squeeze(omega_trend(:,:,t));
    parms_t = [theta_t;gamma_t;psi_g_t;psi_x_t;psi_nx_t;Phi_t(:);Omega_t(:)]; 
    va_trend_excl_nx_g(t,:) = sV_compute(parms_t,nS)';
end


% -- Figure 2 -- %
i_loc = [3 1 2 4 5];
for i = 1:nS
    figure('Units','Inches','Position',[1 1 2 2]);
    hold on;
    plot(calvec,va_shares(:,i),'- k','LineWidth',1)
    plot(calvec,va_shares_trend(:,i),'- k','LineWidth',2)
    plot(calvec,theta(:,i),'- r','LineWidth',1);
    plot(calvec,theta_trend(:,i),'-- r','LineWidth',2);
    plot(calvec,va_excl_nx_g(:,i),'- b','LineWidth',1);
    plot(calvec,va_trend_excl_nx_g(:,i),': b','LineWidth',2);
    hold off;
    ylim([0.0 0.20]);
    xlim([1940 2020]);
    if i_loc(i) == 5
        ylim([0.45 0.85]);
    elseif i_loc(i) == 4
        ylim([0.0 0.40]);
    end
    % title(char(SecName(i)));

    % if i_loc(i) == 1
    %    legend('Value Added Shares','Consumption Shares','Value Added Shares (Excl. NX & G)','Location','NorthWest','FontSize',ax_fs);
    % end
    box on
    grid on;
    print('-depsc',[figdir 'Figure_2_' num2str(i_loc(i))])
end

% Add in Sum of Const, Durables and IPP
fig = figure('Units','Inches','Position',[1 1 2 2]);
hold on
plot(calvec,sum(va_shares(:,1:3),2),'- k','LineWidth',1)
plot(calvec,sum(va_shares_trend(:,1:3),2),'- k','LineWidth',2)
plot(calvec,sum(theta(:,1:3),2),'- r','LineWidth',1);
plot(calvec,sum(theta_trend(:,1:3),2),'-- r','LineWidth',2);
plot(calvec,sum(va_excl_nx_g(:,1:3),2),'- b','LineWidth',1);
plot(calvec,sum(va_trend_excl_nx_g(:,1:3),2),': b','LineWidth',2);
hold off;
ylim([0.0 0.40]);
xlim([1940 2020]);
% title('Durables+IPP+Const.','FontSize',ax_fs);
% ax = gca;
% ax.FontSize = ax_fs;
grid on;
box on
print('-depsc',[figdir 'Figure_2_6'])
% fname = ['Figure_2'];
% figure_to_png(figdir,fname);
% close(fig); 



% -- Figure 3 -- %
% Indices for sectors
i_dur = 2;
i_ndur = 4;
i_serv = 5;
i_const = 1;
i_ipp = 3;

for i = 1:6
    if i == 1
        TMP = omega;
        TMP_trend = omega_trend;
        jj = i_dur;
        tit_str = 'Durable Goods Investment';
        ylim1 = [0 0.8];
    elseif i == 2
        TMP = omega;
        TMP_trend = omega_trend;
        jj = i_ndur;
        tit_str = 'Nondurable Goods Investment';
        ylim1 = [0 0.6];
    elseif i == 3
        TMP = omega;
        TMP_trend = omega_trend;
        jj = i_serv;
        tit_str = 'Sevices Investment';
        ylim1 = [0 0.4];
    elseif i == 4
        TMP = phi;
        TMP_trend = phi_trend;
        jj = i_dur;
        tit_str = 'Durable Goods Materials';
        ylim1 = [0 0.8];
    elseif i == 5
        TMP = phi;
        TMP_trend = phi_trend;
        jj = i_ndur;
        tit_str = 'Nondurable Goods Materials';
        ylim1 = [0 0.1];
    elseif i == 6
        TMP = phi;
        TMP_trend = phi_trend;
        jj = i_serv;
        tit_str = 'Services Materials';
        ylim1 = [0 0.2];
    end
    fig = figure('Units','Inches','Position',[1 1 2 2]);
    x_dur = squeeze(TMP(i_dur,jj,:));
    x_dur_trend = squeeze(TMP_trend(i_dur,jj,:));
    x_ipp = squeeze(TMP(i_ipp,jj,:));
    x_ipp_trend = squeeze(TMP_trend(i_ipp,jj,:));
    hold on;
    plot(calvec,x_dur,'- b','LineWidth',1);
    plot(calvec,x_dur_trend,'- b','LineWidth',2);
    plot(calvec,x_ipp,'- r','LineWidth',1);
    plot(calvec,x_ipp_trend,'-- r','LineWidth',2);
    hold off;
    % title(tit_str,'FontSize',ax_fs);
    ylim(ylim1);
    xlim([1940 2020])
    % ax = gca;
    % ax.FontSize = ax_fs;
    grid on;
    box on
    print('-depsc',[figdir 'Figure_3_' num2str(i)])
    % if i == 1
    %     legend('Durable Goods Spending Share','IPP Spending Share','Location','NorthWest','FontSize',ax_fs);
    % end

end
% fname = ['Figure_3'];
% figure_to_png(figdir,fname);
% close(fig); 


% -- Figure 4 -- %
psi_nxg = psiNX + psiG;
psi_nxg_trend = psiNX_trend + psiG_trend;

i_loc = [3 1 2 4 5];
for i = 1:nS
    fig = figure('Units','Inches','Position',[1 1 2 2]);
    hold on
    plot(calvec,psi_nxg(:,i),'- b','LineWidth',1)
    plot(calvec,psi_nxg_trend(:,i),'- b','LineWidth',2)
    % ylim([0.0 0.20]);
    xlim([1940 2020]);
    if i_loc(i) == 5
        ylim([0.2 0.35]);
    elseif i_loc(i) == 4
        ylim([-0.4 0.10]);
    elseif i_loc(i) == 2
        ylim([0.0 0.07]);
    elseif i_loc(i) == 1
        ylim([-0.6 0.4]);
    elseif i_loc(i) == 3
        ylim([0.0 0.02]);
    end
    % title(char(SecName(i)),'FontSize',ax_fs);
    % ax = gca;
    % ax.FontSize = ax_fs;
    grid on;
    box on
    print('-depsc',[figdir 'Figure_4_' num2str(i_loc(i))])
end
% fname = ['Figure_4'];
% figure_to_png(figdir,fname);
% close(fig); 

save([matdir 'psi_process'],'psi_nxg','psi_nxg_trend');

% --------------------  Functions ----------------------

function[theta,gamma,psi_x,psi_g,psi_nx,Phi,Omega] = parms_to_system_matrices(parms,nS)
    k = 0;
    theta = parms(k+1:k+nS);
    k = k+nS;
    gamma = parms(k+1:k+nS);
    k = k+nS;
    psi_g = parms(k+1:k+nS);
    k = k+nS;
    psi_x = parms(k+1:k+nS);
    k = k+nS;
    psi_nx = parms(k+1:k+nS);
    k = k+nS;
    Phi = reshape(parms(k+1:k+nS^2),nS,nS);
    k = k+nS^2;
    Omega = reshape(parms(k+1:k+nS^2),nS,nS);
end


function sV_fit = sV_compute(parms,nS)
    [theta,gamma,psi_x,psi_g,psi_nx,Phi,Omega] = parms_to_system_matrices(parms,nS);
    D_X = diag(psi_x);
    D_G = diag(psi_g);
    D_NX = diag(psi_nx);
    D_Gam = diag(gamma);
    D_Gam_inv = diag(1./gamma);
    tmp = eye(nS)-Phi*(eye(nS)-D_Gam);
    tmp = tmp*D_Gam_inv;
    tmp = tmp-Omega*D_X-D_G-D_NX;
    Psi = (tmp\theta);
    sV_fit = Psi./sum(Psi);
end
